<?php
require_once '../config.php';
$keys = $conn->query("SELECT * FROM `auth_keys` ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="vi">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Quản lý Key</title>
<style>
body{font-family:system-ui,Arial;background:#f2f4f7;margin:0;padding:0;}
header{background:#0078ff;color:#fff;text-align:center;padding:10px;font-weight:bold;}
.container{max-width:1000px;margin:20px auto;background:#fff;border-radius:10px;padding:15px;box-shadow:0 2px 8px rgba(0,0,0,0.1);}
button,input{border:none;outline:none;padding:8px 10px;border-radius:6px;font-size:14px;}
button{background:#0078ff;color:white;cursor:pointer;}button:hover{background:#005fcc;}
table{width:100%;border-collapse:collapse;margin-top:10px;font-size:14px;}
th,td{border-bottom:1px solid #ddd;padding:8px;text-align:center;}th{background:#0078ff;color:white;}
a{color:#0078ff;text-decoration:none;}
.modal{display:none;position:fixed;top:0;left:0;width:100%;height:100%;background:rgba(0,0,0,0.6);align-items:center;justify-content:center;}
.modal-content{background:#fff;padding:20px;border-radius:10px;width:90%;max-width:400px;}
.toast{position:fixed;top:20px;right:20px;background:#0078ff;color:white;padding:10px 20px;border-radius:6px;display:none;}
@media(max-width:600px){th,td{font-size:12px;}}
</style>
<script>
function openForm(id='',name='',code='',max='',hsd=''){
 document.getElementById('formId').value=id;
 document.getElementById('nameKey').value=name;
 document.getElementById('keyCode').value=code;
 document.getElementById('maxUse').value=max;
 document.getElementById('expiry').value=hsd;
 document.getElementById('modal').style.display='flex';
}
function closeForm(){document.getElementById('modal').style.display='none';}
function toast(msg){var t=document.getElementById('toast');t.innerText=msg;t.style.display='block';setTimeout(()=>t.style.display='none',2000);}
</script>
</head>
<body>
<header>🔑 Quản lý Key</header>
<div class="container">
<button onclick="openForm()">➕ Tạo Key</button>
<table>
<tr><th>ID</th><th>Tên</th><th>Key</th><th>Sử dụng</th><th>HSD</th><th>Hành động</th></tr>
<?php foreach($keys as $k): ?>
<tr>
<td><?= $k['id'] ?></td>
<td><?= htmlspecialchars($k['name_key']) ?></td>
<td><?= htmlspecialchars($k['key_code']) ?></td>
<td><?= $k['used_count'] ?>/<?= $k['max_use'] ?></td>
<td><?= $k['expiry_date'] ?></td>
<td>
<a href="javascript:void(0)" onclick="openForm('<?= $k['id'] ?>','<?= $k['name_key'] ?>','<?= $k['key_code'] ?>','<?= $k['max_use'] ?>','<?= substr($k['expiry_date'],0,10) ?>')">✏️</a> |
<a href="process.php?reset=<?= $k['id'] ?>">♻️</a> |
<a href="process.php?delete=<?= $k['id'] ?>">🗑️</a>
</td>
</tr>
<?php endforeach; ?>
</table>
</div>

<div id="modal" class="modal">
<div class="modal-content">
<h3 id="formTitle">🔧 Quản lý Key</h3>
<form method="post" action="process.php">
<input type="hidden" id="formId" name="id">
<label>Tên Key</label><br><input type="text" id="nameKey" name="name_key" required><br><br>
<label>Mã Key</label><br><input type="text" id="keyCode" name="key_code" required><br><br>
<label>Giới hạn</label><br><input type="number" id="maxUse" name="max_use" required><br><br>
<label>Hạn sử dụng</label><br><input type="date" id="expiry" name="expiry_date" required><br><br>
<button name="save">Lưu</button>
<button type="button" onclick="closeForm()">Đóng</button>
</form>
</div>
</div>

<div id="toast" class="toast"></div>
</body>
</html>
