<?php
require_once 'config.php';
header('Content-Type: application/json');

$key = isset($_GET['key']) ? trim($_GET['key']) : null;
$ip  = $_SERVER['REMOTE_ADDR'];
$time = date("Y-m-d H:i:s");

if (!$key) {
    echo json_encode(["TrangThai" => "ThatBai", "Mess" => "Thiếu tham số key"]);
    exit;
}

$stmt = $conn->prepare("SELECT * FROM `auth_keys` WHERE key_code = :key");
$stmt->execute([':key' => $key]);
$keyData = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$keyData) {
    echo json_encode(["TrangThai" => "ThatBai", "Mess" => "Key không hợp lệ"]);
    exit;
}

if (strtotime($keyData['expiry_date']) < time()) {
    echo json_encode(["TrangThai" => "ThatBai", "Mess" => "Key đã hết hạn"]);
    exit;
}

if ($keyData['used_count'] >= $keyData['max_use']) {
    echo json_encode(["TrangThai" => "ThatBai", "Mess" => "Key đã đạt giới hạn sử dụng"]);
    exit;
}

$conn->prepare("UPDATE `auth_keys` SET used_count = used_count + 1 WHERE id = :id")
     ->execute([':id' => $keyData['id']]);

$conn->prepare("INSERT INTO `auth_logs`(key_id, key_code, ip, login_time) VALUES(:id, :key, :ip, :time)")
     ->execute([':id' => $keyData['id'], ':key' => $key, ':ip' => $ip, ':time' => $time]);

echo json_encode([
    "TrangThai" => "ThanhCong",
    "Mess" => "Đăng nhập thành công!",
    "Key" => $key,
    "NameKey" => $keyData['name_key'],
    "SuDung" => "{$keyData['used_count']}/{$keyData['max_use']}",
    "HSD" => $keyData['expiry_date']
]);
?>
